<?php
// ---------------- STATE HANDLER ----------------
// ذخیره state در دیتابیس یا فایل ساده
// این نسخه از دیتابیس استفاده می‌کند
// جدول: user_states (user_id INT PRIMARY KEY, state TEXT)

function getUserState($user_id){
    $pdo = db();
    $stmt = $pdo->prepare("SELECT state FROM user_states WHERE user_id=?");
    $stmt->execute([$user_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if($row) return json_decode($row['state'],true);
    return [];
}

function setUserState($user_id,$state){
    $pdo = db();
    $state_json = json_encode($state);
    $stmt = $pdo->prepare("INSERT INTO user_states(user_id,state) VALUES(?,?)
        ON DUPLICATE KEY UPDATE state=?");
    $stmt->execute([$user_id,$state_json,$state_json]);
}

function clearUserState($user_id){
    $pdo = db();
    $stmt = $pdo->prepare("DELETE FROM user_states WHERE user_id=?");
    $stmt->execute([$user_id]);
}
