<?php
require_once 'functions.php';
require_once 'state.php';

$update = json_decode(file_get_contents('php://input'), true);
$chat_id = $update['message']['chat']['id'] ?? $update['callback_query']['message']['chat']['id'];
$text = $update['message']['text'] ?? '';
$data_cb = $update['callback_query']['data'] ?? null;

$pdo = db();

// بررسی ثبت نام
$stmt = $pdo->prepare("SELECT * FROM users WHERE id=?");
$stmt->execute([$chat_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// دریافت state
$state = getUserState($chat_id);

// ---------- ثبت نام مرحله‌ای ----------
if(!$user){
    if(empty($state)){
        if($text=='/start'){
            sendMessage($chat_id,"👋 سلام! برای استفاده از ربات باید ثبت نام کنید.\nلطفاً شماره تماس خود را ارسال کنید:");
            setUserState($chat_id,['step'=>'phone']);
            exit;
        }
    } elseif($state['step']=='phone'){
        $phone = encrypt($text);
        $stmt = $pdo->prepare("INSERT INTO users(id,phone,register_date) VALUES(?,?,?)");
        $stmt->execute([$chat_id,$phone,today_shamsi()]);
        sendMessage($chat_id,"✅ شماره تماس ثبت شد.\nنام خود را ارسال کنید:");
        setUserState($chat_id,['step'=>'first_name']);
        exit;
    } elseif($state['step']=='first_name'){
        $state['first_name']=encrypt($text);
        $state['step']='last_name';
        setUserState($chat_id,$state);
        sendMessage($chat_id,"نام خانوادگی خود را ارسال کنید:");
        exit;
    } elseif($state['step']=='last_name'){
        $state['last_name']=encrypt($text);
        $state['step']='gender';
        setUserState($chat_id,$state);
        $buttons = [
            [['text'=>'👨 مرد','callback_data'=>'gender_m']],
            [['text'=>'👩 زن','callback_data'=>'gender_f']]
        ];
        sendButton($chat_id,"جنسیت خود را انتخاب کنید:",$buttons);
        exit;
    } elseif(isset($data_cb) && ($data_cb=='gender_m'||$data_cb=='gender_f')){
        $gender = $data_cb=='gender_m'?'مرد':'زن';
        $stmt = $pdo->prepare("UPDATE users SET first_name=?,last_name=?,gender=? WHERE id=?");
        $stmt->execute([$state['first_name'],$state['last_name'],$gender,$chat_id]);
        clearUserState($chat_id);
        sendMessage($chat_id,"✅ ثبت نام با موفقیت انجام شد!");
        // منوی اصلی
        $buttons = [
            [['text'=>'📌 ثبت آگهی']],
            [['text'=>'📌 آگهی‌های من']],
            [['text'=>'📌 پروفایل من']],
            [['text'=>'📌 درباره ما']]
        ];
        sendButton($chat_id,"📋 منوی اصلی:",$buttons);
        exit;
    }
}
// ---------- منوی اصلی کاربر ----------
if($user && $text){
    switch($text){
        case '📌 ثبت آگهی':
            // بررسی محدودیت تعداد آگهی در ماه
            $stmt = $pdo->prepare("SELECT COUNT(*) FROM ads WHERE user_id=? AND created_at >= ?");
            $stmt->execute([$chat_id,date('Y-m-d', strtotime('-30 days'))]);
            $count = $stmt->fetchColumn();
            if($count >= MAX_ADS_PER_USER){
                sendMessage($chat_id,"⚠️ شما در این ماه به حد مجاز آگهی‌ها رسیدید.");
                exit;
            }

            setUserState($chat_id,['step'=>'ad_type']);
            $buttons = [
                [['text'=>'💰 فروش','callback_data'=>'ad_sell']],
                [['text'=>'🏠 اجاره','callback_data'=>'ad_rent']]
            ];
            sendButton($chat_id,"آگهی برای فروش است یا اجاره؟",$buttons);
            exit;

        case '📌 آگهی‌های من':
            $stmt = $pdo->prepare("SELECT * FROM ads WHERE user_id=?");
            $stmt->execute([$chat_id]);
            $ads = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if(!$ads) sendMessage($chat_id,"📭 شما هیچ آگهی ثبت شده‌ای ندارید.");
            else {
                foreach($ads as $ad){
                    $msg = "🆔 #{$ad['id']} | {$ad['ad_type']} {$ad['property_type']}\n✳️ عنوان: {$ad['title']}\n💵 قیمت: {$ad['price']}";
                    $buttons = [[['text'=>'❌ حذف','callback_data'=>'delete_'.$ad['id']]]];
                    sendButton($chat_id,$msg,$buttons);
                }
            }
            exit;

        case '📌 پروفایل من':
            $msg = "👤 نام: ".decrypt($user['first_name'])." ".decrypt($user['last_name'])."\n".
                   "☎️ شماره: ".decrypt($user['phone'])."\n".
                   "جنسیت: {$user['gender']}\n".
                   "تاریخ عضویت: {$user['register_date']}";
            $buttons = [[['text'=>'❌ حذف حساب','callback_data'=>'delete_user']]];
            sendButton($chat_id,$msg,$buttons);
            exit;

        case '📌 درباره ما':
            sendMessage($chat_id,"📝 این ربات توسط مدیریت ایجاد شده است. متن درباره ما قابل تنظیم می‌باشد.");
            exit;
    }
}

// ---------- ثبت آگهی مرحله‌ای (callback) ----------
if($state && isset($data_cb)){
    switch($state['step']){
        case 'ad_type':
            $state['ad_type']=$data_cb=='ad_sell'?'فروش':'اجاره';
            $state['step']='property_type';
            setUserState($chat_id,$state);

            $buttons = [
                [['text'=>'🏡 آپارتمان','callback_data'=>'prop_apartment']],
                [['text'=>'🏠 ویلایی','callback_data'=>'prop_villa']],
                [['text'=>'🌳 زمین','callback_data'=>'prop_land']],
                [['text'=>'🏢 تجاری','callback_data'=>'prop_commercial']],
                [['text'=>'🛢 انباری','callback_data'=>'prop_storage']]
            ];
            sendButton($chat_id,"نوع ملک را انتخاب کنید:",$buttons);
            exit;

        case 'property_type':
            $map = ['prop_apartment'=>'آپارتمان','prop_villa'=>'ویلایی','prop_land'=>'زمین','prop_commercial'=>'تجاری','prop_storage'=>'انباری'];
            $state['property_type']=$map[$data_cb];
            $state['step']='title';
            setUserState($chat_id,$state);
            sendMessage($chat_id,"عنوان آگهی را وارد کنید:");
            exit;
    }
}

// ---------- ادامه ثبت آگهی با متن ----------
if($state && isset($state['step'])){
    switch($state['step']){
        case 'title':
            $state['title']=$text;
            $state['step']='area';
            setUserState($chat_id,$state);
            sendMessage($chat_id,"متراژ ملک را به متر مربع وارد کنید (فقط عدد):");
            exit;

        case 'area':
            if(!is_numeric($text)){
                sendMessage($chat_id,"⚠️ لطفاً فقط عدد وارد کنید:");
                exit;
            }
            $state['area']=$text;
            $state['step']='price';
            setUserState($chat_id,$state);
            if($state['ad_type']=='اجاره'){
                sendMessage($chat_id,"قیمت رهن و کرایه ماهانه را وارد کنید (فقط عدد):");
            } else {
                sendMessage($chat_id,"قیمت فروش را وارد کنید (فقط عدد):");
            }
            exit;

        case 'price':
            if(!is_numeric($text)){
                sendMessage($chat_id,"⚠️ لطفاً فقط عدد وارد کنید:");
                exit;
            }
            $state['price']=$text;
            $state['step']='address';
            setUserState($chat_id,$state);
            sendMessage($chat_id,"آدرس ملک را وارد کنید:");
            exit;

        case 'address':
            $state['address']=$text;
            $state['step']='description';
            setUserState($chat_id,$state);
            sendMessage($chat_id,"توضیحات تکمیلی آگهی را وارد کنید (اختیاری):");
            exit;

        case 'description':
            $state['description']=$text;
            $state['step']='photos';
            setUserState($chat_id,$state);
            $buttons = [[['text'=>'📷 ثبت بدون تصویر','callback_data'=>'no_photo']]];
            sendButton($chat_id,"حداکثر ۴ تصویر ارسال کنید یا ثبت بدون تصویر:",$buttons);
            exit;
    }
}

// ---------- دریافت تصاویر ----------
if($state && $state['step']=='photos'){
    if(isset($update['message']['photo'])){
        $photos = $state['photos'] ?? [];
        $photo_file_id = end($update['message']['photo'])['file_id'];
        $photos[]=$photo_file_id;
        $state['photos']=$photos;
        setUserState($chat_id,$state);

        if(count($photos)>=4){
            // ذخیره آگهی
            $stmt = $pdo->prepare("INSERT INTO ads(user_id,ad_type,property_type,title,area,price,address,description,photos,status,created_at,expire_at) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $expire = date('Y-m-d', strtotime('+'.AD_EXPIRE_DAYS.' days'));
            $stmt->execute([$chat_id,$state['ad_type'],$state['property_type'],$state['title'],$state['area'],$state['price'],$state['address'],$state['description'],json_encode($state['photos']),'pending',today_shamsi(),$expire]);
            clearUserState($chat_id);
            sendMessage($chat_id,"✅ آگهی شما ثبت شد و منتظر تایید مدیر می‌باشد.");
        } else {
            sendMessage($chat_id,"📷 تصویر دریافت شد. می‌توانید تصویر بعدی را ارسال کنید یا روی ثبت بدون تصویر کلیک کنید.");
        }
        exit;
    }

    if(isset($data_cb) && $data_cb=='no_photo'){
        $stmt = $pdo->prepare("INSERT INTO ads(user_id,ad_type,property_type,title,area,price,address,description,photos,status,created_at,expire_at) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $expire = date('Y-m-d', strtotime('+'.AD_EXPIRE_DAYS.' days'));
        $stmt->execute([$chat_id,$state['ad_type'],$state['property_type'],$state['title'],$state['area'],$state['price'],$state['address'],$state['description'],json_encode([]),'pending',today_shamsi(),$expire]);
        clearUserState($chat_id);
        sendMessage($chat_id,"✅ آگهی شما ثبت شد و منتظر تایید مدیر می‌باشد.");
        exit;
    }
}
// ---------- حذف آگهی ----------
if($state && isset($data_cb) && strpos($data_cb,'delete_')===0){
    $ad_id = str_replace('delete_','',$data_cb);

    // حذف از کانال و دیتابیس
    $stmt = $pdo->prepare("SELECT * FROM ads WHERE id=?");
    $stmt->execute([$ad_id]);
    $ad = $stmt->fetch(PDO::FETCH_ASSOC);
    if($ad){
        deleteAd($ad_id); // تابع deleteAd پیام کانال و دیتابیس را حذف می‌کند
        sendMessage($chat_id,"✅ آگهی با موفقیت حذف شد.");
    }
    exit;
}

// ---------- حذف حساب کاربری ----------
if($state && $data_cb=='delete_user'){
    $buttons = [
        [['text'=>'✅ بله','callback_data'=>'confirm_delete_user']],
        [['text'=>'❌ خیر','callback_data'=>'cancel_delete_user']]
    ];
    sendButton($chat_id,"آیا مطمئن هستید که می‌خواهید حساب کاربری خود را حذف کنید؟",$buttons);
    exit;
}

if($state && $data_cb=='confirm_delete_user'){
    $stmt = $pdo->prepare("DELETE FROM users WHERE id=?");
    $stmt->execute([$chat_id]);
    $stmt = $pdo->prepare("DELETE FROM ads WHERE user_id=?");
    $stmt->execute([$chat_id]);
    clearUserState($chat_id);
    sendMessage($chat_id,"🗑 حساب کاربری و تمام آگهی‌های شما حذف شد.");
    exit;
}

if($state && $data_cb=='cancel_delete_user'){
    clearUserState($chat_id);
    sendMessage($chat_id,"❌ حذف حساب لغو شد.");
    exit;
}