<?php
require_once 'db.php';
require_once 'functions_crypto.php';

// ارسال پیام ساده
function sendMessage($chat_id, $text, $keyboard = null) {
    $params = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    return apiRequest('sendMessage', $params);
}

// حذف از کانال
function deleteFromChannel($message_id) {
    return apiRequest('deleteMessage', [
        'chat_id' => CHANNEL_ID,
        'message_id' => $message_id
    ]);
}

// رمزنگاری و ذخیره کاربر
function saveUserEncrypted($telegram_id, $fullname, $phone) {
    global $mysqli;
    $fullname_enc = encrypt_secret($fullname);
    $phone_enc = encrypt_secret($phone);
    $join_date = date('Y-m-d');
    $stmt = $mysqli->prepare("INSERT INTO users (telegram_id, fullname_enc, phone_enc, join_date)
        VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE fullname_enc=VALUES(fullname_enc), phone_enc=VALUES(phone_enc)");
    $stmt->bind_param('isss', $telegram_id, $fullname_enc, $phone_enc, $join_date);
    $stmt->execute();
}

// واکشی کاربر
function getUser($telegram_id) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT * FROM users WHERE telegram_id=?");
    $stmt->bind_param('i', $telegram_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $u = $res->fetch_assoc();
    if ($u) {
        $u['fullname'] = decrypt_secret($u['fullname_enc']);
        $u['phone'] = decrypt_secret($u['phone_enc']);
    }
    return $u;
}

// ثبت آگهی
function saveAd($user_id, $data, $chat_id) {
    global $mysqli;
    $images = isset($data['images']) ? json_encode($data['images'], JSON_UNESCAPED_UNICODE) : '';
    $stmt = $mysqli->prepare("INSERT INTO ads (user_id, type, property_type, title, area, price, address, description, images, status)
                              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending')");
    $stmt->bind_param('isssissss', $user_id, $data['type'], $data['property_type'], $data['title'], $data['area'],
                      $data['price'], $data['address'], $data['description'], $images);
    $stmt->execute();
    sendMessage($chat_id, "✅ آگهی شما ثبت شد و پس از تأیید مدیر منتشر خواهد شد.");
}

// ارسال آگهی به کانال
function sendAdToChannel($ad_id) {
    global $mysqli;
    $ad = $mysqli->query("SELECT a.*, u.fullname_enc, u.phone_enc 
                          FROM ads a JOIN users u ON a.user_id=u.telegram_id WHERE a.id=$ad_id")->fetch_assoc();
    if (!$ad) return false;

    $name = decrypt_secret($ad['fullname_enc']);
    $phone = decrypt_secret($ad['phone_enc']);
    $msg = "🏠 <b>{$ad['title']}</b>\n"
         . "📏 متراژ: {$ad['area']} متر\n"
         . "🏷 {$ad['property_type']} | {$ad['type']}\n"
         . "💰 {$ad['price']}\n"
         . "📍 {$ad['address']}\n"
         . "📝 {$ad['description']}\n\n"
         . "👤 $name\n📞 <a href='tel:$phone'>$phone</a>";

    $images = json_decode($ad['images'], true);
    if (is_array($images) && count($images) > 0) {
        $media = [];
        foreach ($images as $i => $file_id) {
            $item = ['type' => 'photo', 'media' => $file_id];
            if ($i == 0) $item['caption'] = $msg;
            $media[] = $item;
        }
        $res = apiRequest('sendMediaGroup', [
            'chat_id' => CHANNEL_ID,
            'media' => json_encode($media, JSON_UNESCAPED_UNICODE),
            'parse_mode' => 'HTML'
        ]);
        $msg_id = $res['result'][0]['message_id'] ?? 0;
    } else {
        $res = apiRequest('sendMessage', [
            'chat_id' => CHANNEL_ID,
            'text' => $msg,
            'parse_mode' => 'HTML'
        ]);
        $msg_id = $res['result']['message_id'] ?? 0;
    }
    $mysqli->query("UPDATE ads SET status='approved', message_id_in_channel=$msg_id WHERE id=$ad_id");
}

// حذف آگهی (DB و کانال)
function deleteAd($ad_id) {
    global $mysqli;
    $res = $mysqli->query("SELECT message_id_in_channel FROM ads WHERE id=$ad_id")->fetch_assoc();
    if ($res && $res['message_id_in_channel']) deleteFromChannel($res['message_id_in_channel']);
    $mysqli->query("UPDATE ads SET status='deleted' WHERE id=$ad_id");
}

// ذخیره وضعیت مرحله ثبت آگهی
function setStep($uid, $step, $data = []) {
    $path = __DIR__ . "/sessions/$uid.json";
    file_put_contents($path, json_encode(array_merge(['step' => $step], $data), JSON_UNESCAPED_UNICODE));
}
function getStep($uid) {
    $p = __DIR__ . "/sessions/$uid.json";
    return file_exists($p) ? json_decode(file_get_contents($p), true) : null;
}
function clearStep($uid) {
    $p = __DIR__ . "/sessions/$uid.json";
    if (file_exists($p)) unlink($p);
}
