<?php
require_once 'functions.php';

// دریافت آپدیت
$update = json_decode(file_get_contents('php://input'), true);
if (!$update) exit;

// بررسی نوع آپدیت
$message = $update['message'] ?? null;
$callback = $update['callback_query'] ?? null;
$user_id = $message['from']['id'] ?? ($callback['from']['id'] ?? null);
$chat_id = $message['chat']['id'] ?? ($callback['message']['chat']['id'] ?? null);
$text = trim($message['text'] ?? '');
$user = getUser($user_id);

// کاربر مسدود
if ($user && $user['is_blocked']) {
    sendMessage($chat_id, "🚫 حساب شما توسط مدیریت مسدود شده است.");
    exit;
}

/* ==============================
   ثبت‌نام کاربر جدید
============================== */
if ($text == '/start') {
    if (!$user) {
        $keyboard = [
            'keyboard' => [
                [['text' => "📱 ارسال شماره من", 'request_contact' => true]]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => true
        ];
        sendMessage($chat_id, "👋 خوش آمدید!\nبرای استفاده از ربات، لطفاً شماره تماس خود را ارسال کنید:", $keyboard);
    } else {
        showMainMenu($chat_id);
    }
    exit;
}

if (isset($message['contact'])) {
    $phone = $message['contact']['phone_number'];
    file_put_contents("sessions/register_$user_id.json", json_encode(['phone' => $phone]));
    sendMessage($chat_id, "✅ شماره ثبت شد.\nلطفاً نام و نام خانوادگی خود را ارسال کنید:");
    exit;
}

if (file_exists("sessions/register_$user_id.json") && !$user && $text) {
    $temp = json_decode(file_get_contents("sessions/register_$user_id.json"), true);
    saveUserEncrypted($user_id, $text, $temp['phone']);
    unlink("sessions/register_$user_id.json");
    sendMessage($chat_id, "🎉 ثبت‌نام شما با موفقیت انجام شد.");
    showMainMenu($chat_id);
    exit;
}

/* ==============================
   منوی اصلی
============================== */
function showMainMenu($chat_id) {
    $keyboard = [
        'keyboard' => [
            [['text' => "🏠 ثبت آگهی"], ['text' => "📋 آگهی‌های من"]],
            [['text' => "👤 پروفایل من"], ['text' => "ℹ️ درباره سازنده"]]
        ],
        'resize_keyboard' => true
    ];
    sendMessage($chat_id, "📋 منوی اصلی:", $keyboard);
}

/* ==============================
   درباره سازنده
============================== */
if ($text == "ℹ️ درباره سازنده") {
    $res = $mysqli->query("SELECT about_text FROM settings LIMIT 1")->fetch_assoc();
    sendMessage($chat_id, "ℹ️ " . $res['about_text']);
    exit;
}

/* ==============================
   پروفایل من
============================== */
if ($text == "👤 پروفایل من") {
    $fullname = htmlspecialchars($user['fullname']);
    $phone = htmlspecialchars($user['phone']);
    $join_date = htmlspecialchars($user['join_date']);
    $msg = "👤 <b>پروفایل شما</b>\n\n"
         . "نام: <b>$fullname</b>\n"
         . "📞 شماره: <code>$phone</code>\n"
         . "📅 تاریخ عضویت: $join_date";
    sendMessage($chat_id, $msg);
    exit;
}

/* ==============================
   آگهی‌های من
============================== */
if ($text == "📋 آگهی‌های من") {
    $ads = $mysqli->query("SELECT * FROM ads WHERE user_id=$user_id AND status!='deleted' ORDER BY id DESC");
    if ($ads->num_rows == 0) {
        sendMessage($chat_id, "📭 شما هیچ آگهی فعالی ندارید.");
        exit;
    }
    while ($a = $ads->fetch_assoc()) {
        $msg = "🏠 <b>{$a['title']}</b>\n"
             . "📏 {$a['area']} متر | {$a['property_type']} | {$a['type']}\n"
             . "💰 {$a['price']}\n"
             . "📍 {$a['address']}\n"
             . "📝 {$a['description']}";
        $keyboard = ['inline_keyboard' => [[['text' => '❌ حذف آگهی', 'callback_data' => 'delad_' . $a['id']]]]];
        // اگر آگهی عکس دارد، یکی را بفرست
        $imgs = json_decode($a['images'], true);
        if (is_array($imgs) && count($imgs) > 0) {
            apiRequest('sendPhoto', [
                'chat_id' => $chat_id,
                'photo' => $imgs[0],
                'caption' => $msg,
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode($keyboard, JSON_UNESCAPED_UNICODE)
            ]);
        } else {
            sendMessage($chat_id, $msg, $keyboard);
        }
    }
    exit;
}

/* ==============================
   ثبت آگهی جدید
============================== */
if ($text == "🏠 ثبت آگهی") {
    $count = $mysqli->query("SELECT COUNT(*) AS c FROM ads WHERE user_id=$user_id AND MONTH(created_at)=MONTH(NOW()) AND status!='deleted'")->fetch_assoc()['c'];
    if ($count >= DEFAULT_MAX_ADS_PER_MONTH) {
        sendMessage($chat_id, "⚠️ شما به حداکثر تعداد مجاز آگهی در ماه رسیده‌اید.");
        exit;
    }
    $keyboard = ['inline_keyboard' => [[['text' => '🏷 فروش', 'callback_data' => 'type_فروش'], ['text' => '🔑 اجاره', 'callback_data' => 'type_اجاره']]]];
    sendMessage($chat_id, "نوع آگهی را انتخاب کنید:", $keyboard);
    setStep($user_id, 'choose_type');
    exit;
}

/* ==============================
   Callbackها
============================== */
if ($callback) {
    $data = $callback['data'];
    $cid = $callback['message']['chat']['id'];
    $mid = $callback['message']['message_id'];

    // حذف آگهی توسط کاربر
    if (strpos($data, 'delad_') === 0) {
        $ad_id = intval(str_replace('delad_', '', $data));
        deleteAd($ad_id);
        sendMessage($cid, "✅ آگهی حذف شد.");
        exit;
    }

    // مراحل ثبت آگهی
    if (strpos($data, 'type_') === 0) {
        $type = str_replace('type_', '', $data);
        setStep($user_id, 'choose_property', ['type' => $type]);
        $keyboard = [
            'inline_keyboard' => [
                [['text' => 'زمین', 'callback_data' => 'prop_زمین'], ['text' => 'آپارتمان', 'callback_data' => 'prop_آپارتمان']],
                [['text' => 'ویلایی', 'callback_data' => 'prop_ویلایی'], ['text' => 'تجاری', 'callback_data' => 'prop_تجاری']],
                [['text' => 'انباری', 'callback_data' => 'prop_انباری']]
            ]
        ];
        apiRequest('editMessageText', ['chat_id' => $cid, 'message_id' => $mid, 'text' => "🔹 نوع ملک را انتخاب کنید:", 'reply_markup' => json_encode($keyboard, JSON_UNESCAPED_UNICODE)]);
        exit;
    }

    if (strpos($data, 'prop_') === 0) {
        $prop = str_replace('prop_', '', $data);
        $st = getStep($user_id);
        $st['property_type'] = $prop;
        setStep($user_id, 'title', $st);
        apiRequest('editMessageText', ['chat_id' => $cid, 'message_id' => $mid, 'text' => "✏️ عنوان آگهی را بنویسید:"]);
        exit;
    }

    // عملیات مدیر
    if (in_array($user_id, ADMINS)) {
        if (strpos($data, 'approve_') === 0) {
            $ad_id = intval(str_replace('approve_', '', $data));
            sendAdToChannel($ad_id);
            sendMessage($cid, "✅ آگهی تأیید و ارسال شد.");
            exit;
        }
        if (strpos($data, 'reject_') === 0) {
            $ad_id = intval(str_replace('reject_', '', $data));
            deleteAd($ad_id);
            sendMessage($cid, "❌ آگهی حذف شد.");
            exit;
        }
        if (strpos($data, 'block_') === 0) {
            $uid = intval(str_replace('block_', '', $data));
            blockUser($uid, 1);
            sendMessage($cid, "🚫 کاربر مسدود شد.");
            exit;
        }
        if (strpos($data, 'unblock_') === 0) {
            $uid = intval(str_replace('unblock_', '', $data));
            blockUser($uid, 0);
            sendMessage($cid, "✅ کاربر فعال شد.");
            exit;
        }
    }
}

/* ==============================
   مراحل متنی ثبت آگهی
============================== */
$step = getStep($user_id);

if ($step) {
    switch ($step['step']) {
        case 'title':
            $step['title'] = $text;
            setStep($user_id, 'area', $step);
            sendMessage($chat_id, "📏 متراژ ملک (به متر) را وارد کنید:");
            break;

        case 'area':
            if (!is_numeric($text)) {
                sendMessage($chat_id, "⚠️ فقط عدد وارد کنید.");
                break;
            }
            $step['area'] = intval($text);
            if ($step['type'] == 'اجاره') {
                setStep($user_id, 'rent_price', $step);
                sendMessage($chat_id, "💰 مبلغ رهن را وارد کنید (تومان):");
            } else {
                setStep($user_id, 'price', $step);
                sendMessage($chat_id, "💰 قیمت ملک را وارد کنید (تومان):");
            }
            break;

        case 'rent_price':
            if (!is_numeric($text)) { sendMessage($chat_id, "فقط عدد وارد کنید."); break; }
            $step['rent_price'] = $text;
            setStep($user_id, 'rent_month', $step);
            sendMessage($chat_id, "💸 اجاره ماهانه را وارد کنید (تومان):");
            break;

        case 'rent_month':
            if (!is_numeric($text)) { sendMessage($chat_id, "فقط عدد وارد کنید."); break; }
            $step['price'] = "رهن {$step['rent_price']} / اجاره {$text}";
            setStep($user_id, 'address', $step);
            sendMessage($chat_id, "📍 آدرس ملک را بنویسید:");
            break;

        case 'price':
            $step['price'] = $text;
            setStep($user_id, 'address', $step);
            sendMessage($chat_id, "📍 آدرس ملک را بنویسید:");
            break;

        case 'address':
            $step['address'] = $text;
            setStep($user_id, 'desc', $step);
            sendMessage($chat_id, "📝 توضیحات آگهی:");
            break;

        case 'desc':
            $step['description'] = $text;
            setStep($user_id, 'photos', $step);
            sendMessage($chat_id, "📸 حداکثر ۴ عکس ارسال کنید یا بنویسید «بدون تصویر»:");
            break;

        case 'photos':
            if (isset($message['photo'])) {
                $fid = end($message['photo'])['file_id'];
                $step['images'][] = $fid;
                if (count($step['images']) >= 4) {
                    saveAd($user_id, $step, $chat_id);
                    clearStep($user_id);
                } else {
                    setStep($user_id, 'photos', $step);
                    sendMessage($chat_id, "✅ عکس ذخیره شد. عکس بعدی را بفرستید یا بنویسید «پایان».");
                }
                break;
            }
            if (mb_strtolower($text) == 'بدون تصویر' || mb_strtolower($text) == 'پایان') {
                $step['images'] = $step['images'] ?? [];
                saveAd($user_id, $step, $chat_id);
                clearStep($user_id);
                break;
            }
            break;
    }
}

/* ==============================
   پنل مدیریت
============================== */
if ($text == '/admin' && in_array($user_id, ADMINS)) {
    $menu = [
        'keyboard' => [
            [['text' => "👁️ آگهی‌های در انتظار"], ['text' => "👥 کاربران"]],
            [['text' => "📊 آمار"], ['text' => "🔙 خروج"]]
        ],
        'resize_keyboard' => true
    ];
    sendMessage($chat_id, "🛠 پنل مدیریت:", $menu);
    exit;
}

if ($text == "👁️ آگهی‌های در انتظار" && in_array($user_id, ADMINS)) {
    $ads = $mysqli->query("SELECT * FROM ads WHERE status='pending' ORDER BY id ASC LIMIT 10");
    if ($ads->num_rows == 0) { sendMessage($chat_id, "هیچ آگهی در انتظاری نیست."); exit; }
    while ($a = $ads->fetch_assoc()) {
        $msg = "🏠 <b>{$a['title']}</b>\n"
             . "📏 {$a['area']} متر | {$a['property_type']} | {$a['type']}\n"
             . "💰 {$a['price']}\n"
             . "📍 {$a['address']}\n"
             . "📝 {$a['description']}";
        $keyboard = ['inline_keyboard' => [[['text' => '✅ تأیید و ارسال', 'callback_data' => 'approve_' . $a['id']], ['text' => '❌ حذف', 'callback_data' => 'reject_' . $a['id']]]]];
        sendMessage($chat_id, $msg, $keyboard);
    }
    exit;
}

if ($text == "👥 کاربران" && in_array($user_id, ADMINS)) {
    $users = $mysqli->query("SELECT * FROM users ORDER BY id DESC LIMIT 10");
    while ($u = $users->fetch_assoc()) {
        $name = decrypt_secret($u['fullname_enc']);
        $phone = decrypt_secret($u['phone_enc']);
        $status = $u['is_blocked'] ? "🚫 مسدود" : "✅ فعال";
        $keyboard = ['inline_keyboard' => [[['text' => $u['is_blocked'] ? 'رفع انسداد' : 'مسدود', 'callback_data' => ($u['is_blocked'] ? 'unblock_' : 'block_') . $u['telegram_id']]]]];
        sendMessage($chat_id, "👤 $name\n📞 $phone\n📅 {$u['join_date']}\nوضعیت: $status", $keyboard);
    }
    exit;
}

if ($text == "📊 آمار" && in_array($user_id, ADMINS)) {
    $users = $mysqli->query("SELECT COUNT(*) AS c FROM users")->fetch_assoc()['c'];
    $ads = $mysqli->query("SELECT COUNT(*) AS c FROM ads WHERE status='approved'")->fetch_assoc()['c'];
    $pending = $mysqli->query("SELECT COUNT(*) AS c FROM ads WHERE status='pending'")->fetch_assoc()['c'];
    sendMessage($chat_id, "📊 آمار:\n👥 کاربران: $users\n📢 آگهی‌های فعال: $ads\n⌛ در انتظار: $pending");
    exit;
}
