<?php
if(!defined('IN_BOT')) exit;

require 'config.php';
require 'db.php';

// ==================== رمزنگاری AES-256 ====================
function encryptData($data){
    $key = AES_KEY;
    $iv = substr(hash('sha256', $key), 0, 16);
    return openssl_encrypt($data, 'AES-256-CBC', $key, 0, $iv);
}

function decryptData($data){
    $key = AES_KEY;
    $iv = substr(hash('sha256', $key), 0, 16);
    return openssl_decrypt($data, 'AES-256-CBC', $key, 0, $iv);
}

// ==================== ارسال پیام ====================
function sendMessage($chat_id, $text, $reply_markup=null){
    $url = "https://api.telegram.org/bot".BOT_TOKEN."/sendMessage";
    $data = [
        'chat_id'=>$chat_id,
        'text'=>$text,
        'parse_mode'=>'Markdown'
    ];
    if($reply_markup){
        $data['reply_markup'] = json_encode($reply_markup, JSON_UNESCAPED_UNICODE);
    }
    $options = [
        'http'=>[
            'header'=>"Content-type: application/x-www-form-urlencoded\r\n",
            'method'=>'POST',
            'content'=>http_build_query($data)
        ]
    ];
    file_get_contents($url,false,stream_context_create($options));
}

// ==================== دکمه شیشه‌ای ====================
function buildInlineKeyboard($buttons){
    return ['inline_keyboard'=>$buttons];
}

// ==================== مدیریت مراحل کاربر ====================
function getUserState($chat_id){
    global $pdo;
    $stmt=$pdo->prepare("SELECT * FROM user_state WHERE telegram_id=?");
    $stmt->execute([$chat_id]);
    $row=$stmt->fetch();
    if($row){
        return ['step'=>$row['step'], 'temp_data'=>json_decode($row['temp_data'],true)];
    }
    return ['step'=>null,'temp_data'=>[]];
}

function setUserState($chat_id,$step){
    global $pdo;
    $stmt=$pdo->prepare("INSERT INTO user_state (telegram_id,step,temp_data) VALUES (?,?,?) ON DUPLICATE KEY UPDATE step=?,updated_at=NOW()");
    $stmt->execute([$chat_id,$step,'', $step]);
}

function updateUserState($chat_id,$step,$temp_data){
    global $pdo;
    $stmt=$pdo->prepare("INSERT INTO user_state (telegram_id,step,temp_data) VALUES (?,?,?) ON DUPLICATE KEY UPDATE step=?, temp_data=?, updated_at=NOW()");
    $stmt->execute([$chat_id,$step,json_encode($temp_data, JSON_UNESCAPED_UNICODE), $step, json_encode($temp_data, JSON_UNESCAPED_UNICODE)]);
}

function clearUserState($chat_id){
    global $pdo;
    $stmt=$pdo->prepare("DELETE FROM user_state WHERE telegram_id=?");
    $stmt->execute([$chat_id]);
}

// ==================== بررسی مدیر ====================
function isAdmin($chat_id){
    global $pdo;
    $chat_id = (int)$chat_id;

    // بررسی از config.php
    if(defined('ADMIN_IDS')){
        if(in_array($chat_id, ADMIN_IDS)) return true;
    }
    if(defined('ADMIN_ID')){
        if($chat_id === ADMIN_ID) return true;
    }

    // بررسی از دیتابیس
    $stmt=$pdo->prepare("SELECT * FROM admins WHERE telegram_id=?");
    $stmt->execute([$chat_id]);
    return $stmt->fetch() ? true : false;
}

// ==================== اطلاعات کاربران ====================
function getUserByTelegramId($chat_id){
    global $pdo;
    $stmt=$pdo->prepare("SELECT * FROM users WHERE telegram_id=?");
    $stmt->execute([$chat_id]);
    return $stmt->fetch();
}

function getUserName($chat_id){
    $user = getUserByTelegramId($chat_id);
    return $user ? $user['first_name'].' '.$user['last_name'] : '';
}

function getUserPhone($chat_id){
    $user = getUserByTelegramId($chat_id);
    return $user ? $user['phone'] : '';
}

// ==================== حذف کاربر ====================
function deleteUser($chat_id){
    global $pdo;
    // حذف آگهی‌ها
    $stmt=$pdo->prepare("SELECT * FROM ads WHERE user_id=?");
    $stmt->execute([$chat_id]);
    $ads = $stmt->fetchAll();
    foreach($ads as $ad){
        if(!empty($ad['channel_message_id'])){
            file_get_contents("https://api.telegram.org/bot".BOT_TOKEN."/deleteMessage?".http_build_query([
                'chat_id'=>CHANNEL_ID,
                'message_id'=>$ad['channel_message_id']
            ]));
        }
    }
    $stmt_del = $pdo->prepare("DELETE FROM ads WHERE user_id=?");
    $stmt_del->execute([$chat_id]);

    // حذف کاربر
    $stmt_user = $pdo->prepare("DELETE FROM users WHERE telegram_id=?");
    $stmt_user->execute([$chat_id]);

    // حذف مرحله کاربر
    clearUserState($chat_id);
}

// ==================== حذف آگهی توسط کاربر ====================
function userDeleteAd($ad_id, $chat_id){
    global $pdo;
    $stmt=$pdo->prepare("SELECT * FROM ads WHERE id=? AND user_id=?");
    $stmt->execute([$ad_id,$chat_id]);
    $ad=$stmt->fetch();
    if(!$ad) return;

    if(!empty($ad['channel_message_id'])){
        file_get_contents("https://api.telegram.org/bot".BOT_TOKEN."/deleteMessage?".http_build_query([
            'chat_id'=>CHANNEL_ID,
            'message_id'=>$ad['channel_message_id']
        ]));
    }

    $stmt_del = $pdo->prepare("DELETE FROM ads WHERE id=?");
    $stmt_del->execute([$ad_id]);
}

// ==================== دانلود فایل تلگرام ====================
function downloadTelegramFile($file_id){
    $url = "https://api.telegram.org/bot".BOT_TOKEN."/getFile?file_id=".$file_id;
    $res = json_decode(file_get_contents($url), true);
    $file_path = $res['result']['file_path'];
    $download_url = "https://api.telegram.org/file/bot".BOT_TOKEN."/".$file_path;

    $ext = pathinfo($file_path, PATHINFO_EXTENSION);
    $filename = STORAGE_PATH."/".time()."_".rand(1000,9999).".".$ext;
    file_put_contents($filename, file_get_contents($download_url));
    return $filename;
}

// ==================== تبدیل تاریخ میلادی به شمسی ====================
function jdate($date){
    $ts = strtotime($date);
    return date('Y/m/d',$ts); // نسخه ساده، امکان جایگزینی با کتابخانه jdf
}

// ==================== بررسی محدودیت ثبت آگهی ====================
function canPostAd($chat_id){
    global $pdo;
    $stmt=$pdo->prepare("SELECT COUNT(*) as cnt FROM ads WHERE user_id=? AND status='تایید'");
    $stmt->execute([$chat_id]);
    $row=$stmt->fetch();
    $max_ads = getSetting('max_ads_per_user') ?: 6;
    return $row['cnt'] < $max_ads;
}
