<?php
define('IN_BOT',true);
require 'config.php';
require 'functions.php';
require 'db.php';

// بررسی درخواست POST از ربات
if($_SERVER['REQUEST_METHOD'] !== 'POST'){
    exit('❌ دسترسی غیرمجاز');
}

// دریافت فایل و شناسه کاربر
$chat_id = $_POST['chat_id'] ?? null;
$file_id = $_POST['file_id'] ?? null;

if(!$chat_id || !$file_id){
    exit('❌ اطلاعات ناقص');
}

// دانلود فایل از تلگرام
$local_file = downloadTelegramFile($file_id);

// ذخیره مسیر در دیتابیس (جدیدترین آگهی در مرحله ثبت)
$user_state = getUserState($chat_id);
$temp_data = $user_state['temp_data'] ?? [];
if(!isset($temp_data['images'])) $temp_data['images'] = [];
$temp_data['images'][] = $local_file;

// محدودیت 4 تصویر
if(count($temp_data['images']) > 4){
    array_pop($temp_data['images']);
}

updateUserState($chat_id, $user_state['step'], $temp_data);

echo json_encode([
    'status'=>'success',
    'file'=>$local_file,
    'count'=>count($temp_data['images'])
]);
