<?php
// جلوگیری از دسترسی مستقیم
if(!defined('IN_BOT')) exit;

// ====== تنظیمات اتصال دیتابیس ======
$host = 'localhost';
$dbname = 'real_estate';
$user = 'db_user';
$pass = 'db_pass';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e){
    exit("❌ اتصال به دیتابیس برقرار نشد: ".$e->getMessage());
}

// ====== توابع کمکی برای کار با دیتابیس ======

// دریافت یک تنظیم از جدول bot_settings
function getSetting($key){
    global $pdo;
    $stmt = $pdo->prepare("SELECT value FROM bot_settings WHERE key_name=?");
    $stmt->execute([$key]);
    $row = $stmt->fetch();
    return $row ? $row['value'] : null;
}

// ذخیره یا بروزرسانی تنظیمات
function setSetting($key, $value){
    global $pdo;
    $stmt = $pdo->prepare("INSERT INTO bot_settings (key_name,value) VALUES (?,?) ON DUPLICATE KEY UPDATE value=?");
    $stmt->execute([$key,$value,$value]);
}
