<?php
define('IN_BOT',true);
require 'config.php';
require 'functions.php';

// ====== بررسی آگهی‌های منقضی شده ======
$expiry_days = getSetting('ad_expiry_days') ?: 14;

$stmt = $pdo->prepare("SELECT * FROM ads WHERE status='تایید'");
$stmt->execute();
$ads = $stmt->fetchAll();

foreach($ads as $ad){
    $post_date = strtotime($ad['post_date']);
    $now = time();
    $days_passed = ($now - $post_date)/(60*60*24);

    if($days_passed >= $expiry_days){
        // حذف آگهی از کانال اگر message_id موجود باشد
        if(!empty($ad['channel_message_id'])){
            $url = "https://api.telegram.org/bot".BOT_TOKEN."/deleteMessage?";
            $params = http_build_query([
                'chat_id'=>CHANNEL_ID,
                'message_id'=>$ad['channel_message_id']
            ]);
            file_get_contents($url.$params);
        }

        // حذف از دیتابیس
        $stmt_del = $pdo->prepare("DELETE FROM ads WHERE id=?");
        $stmt_del->execute([$ad['id']]);
        echo "✅ آگهی ".$ad['id']." حذف شد.\n";
    }
}
